Option Explicit
On Error Resume Next

Include "pva-agent-helper.vbs"

' This constant is replaced by the build system. In the result script this bool value will reflect 
' the configfuration of the PVA core. If PVA_MN_CORE is 1, then we work for PVA management node core,
' otherwise the core we deal with is for slave agent.    
const PVA_MN_CORE=1' 1

LogProgress "Executing " & Wscript.ScriptName & " PVA_MN_CORE=" & PVA_MN_CORE

Dim dataDir, installDir
dataDir = SafeGetDataDir(PVA_MN_CORE)
installDir = SafeGetInstallDir(PVA_MN_CORE)

' Call configuration script
If dataDir <> "" Then
	ConfigureCore
Else
	LogError Err.Number, "Failed to find Agent data directory"
End If

If Err.number = 0 Then
	LogProgress Wscript.ScriptName & " finished succesfully"
	WScript.Quit 0
Else
	FailedQuitErr "Failed to execute core preuninstall configuration"
End If

'
' Functions
'
Sub ConfigureCore()
	Dim ret, out, err
	LogProgress "Starting core preuninstall configuration"

	LogProgress "Stopping agent service"
	StopService GetAgentServiceName(PVA_MN_CORE)

	LogProgress "Unregistering agent service"
	UnregisterService GetAgentServiceName(PVA_MN_CORE)

	If PVA_MN_CORE = 1 And IsSQLInstalled Then
		Dim EID
		EID = SafeGetEIDFromConfig(PVA_MN_CORE)

		DropDatabase("VZAgentDB")

	End If

	LogProgress "Deleting VZAgent configuration files"
	' Delete old folders
	Dim oFS
	Set oFS = CreateObject("Scripting.Filesystemobject")
	If dataDir <> "" Then
		LogProgress "Deleting agent data directory"
		DeleteFolderSafe dataDir
	Else
		LogProgress "Can't find agent data directory - skipping deletion"
	End If

	LogProgress "Deleting agent log directory"	
	DeleteFolderSafe GetLogDir(PVA_MN_CORE)

	' Remove Windows firewall program exceptions (for vzlgend)
	If installDir <> "" Then
		If PVA_MN_CORE = 1 Then
			DisableFirewallBypass installDir & "\bin\pvamnd.exe"
		Else
			DisableFirewallBypass installDir & "\bin\pvaagentd.exe"
		End If
	End If
	
	LogProgress "Core preuninstall configuration finished succesfully"
End Sub

Sub DropDatabase(dbName)
	Dim ret, out, err
	LogProgress "Removing database " & dbName
	ret = ExecProgram(GetMSSqlPath & " -S" & PVA_SQL_SERVER_NAME & " -E -l 120 -b -r -Q ""drop database [" & dbName & "]""", "", out, err)
	If ret <> 0 Then LogProgress "Failed to remove database - " & out & err
End Sub

' Include vzlVBLib.vbs
Sub Include(cNameScript)
	On Error Resume Next
	Dim oFS, oFile
	
	cNameScript = Mid(Wscript.ScriptFullName, 1, InStrRev(Wscript.ScriptFullName, "\")) & cNameScript
	
	Set oFS = CreateObject("Scripting.Filesystemobject")
	
	Set oFile = oFS.OpenTextFile(cNameScript)
	If Err.number <> 0 Then
		WScript.Echo "Failed to open include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If
	
	ExecuteGlobal oFile.ReadAll()
	If Err.number <> 0 Then
		WScript.Echo "Failed to ExecuteGlobal include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If

	oFile.Close
End Sub
