Option Explicit
On Error Resume Next

Include "pva-agent-helper.vbs"

' This constant is replaced by the build system. In the result script this bool value will reflect 
' the configfuration of the PVA core. If PVA_MN_CORE is 1, then we work for PVA management node core,
' otherwise the core we deal with is for salve agent.    
const PVA_MN_CORE=1' 0' 1

LogProgress "Executing " & Wscript.ScriptName & " PVA_MN_CORE=" & PVA_MN_CORE

Dim pver_array

' Call configuration script
ConfigureCore

If Err.number = 0 Then
	LogProgress Wscript.ScriptName & " finished succesfully"
	WScript.Quit 0
Else
	FailedQuitErr "Failed to execute " & Wscript.ScriptName
End If

'
' Functions
'
Sub ConfigureCore()
	LogProgress "Starting core preupgrade configuration"

	CheckPreviousVersion

	If pver_array(0) = 4 And pver_array(1) = 5 Then 
		Do45PreUpdate
	Else
		LogError "Only 4.5 -> 4.5 updates are supported"
	End IF
		

	LogProgress "Core preupgrade configuration finished succesfully"
End Sub

Sub CheckPreviousVersion
	Dim installer
	Set installer = CreateObject("WindowsInstaller.Installer")

	LogProgress "Checking if PVA 4.5 is installed"

	Dim related_product
	For Each related_product In installer.RelatedProducts("{8975AF50-46D8-47BB-B506-4C06626005F1}")
		Dim pname, pver

		pname = installer.ProductInfo(related_product, "InstalledProductName")
		pver = installer.ProductInfo(related_product, "VersionString")

		LogProgress "Found installation of '" & pname & "', " & pver

		pver_array = Split(pver, ".")

		If pver_array(0) < 4 Or pver_array(1) < 5 Or pver_array(2) < 1230 Then
			LogError -1, "You can not upgrade from PVA with version less then 4.5-1230"
			WScript.Quit(-1)
		End If
	Next
End Sub

Sub Do45PreUpdate
	StopService GetAgentServiceName(PVA_MN_CORE)
End Sub

' Include vzlVBLib.vbs
Sub Include(cNameScript)
	On Error Resume Next
	Dim oFS, oFile
	
	cNameScript = Mid(Wscript.ScriptFullName, 1, InStrRev(Wscript.ScriptFullName, "\")) & cNameScript
	
	Set oFS = CreateObject("Scripting.Filesystemobject")
	
	Set oFile = oFS.OpenTextFile(cNameScript)
	If Err.number <> 0 Then
		WScript.Echo "Failed to open include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If
	
	ExecuteGlobal oFile.ReadAll()
	If Err.number <> 0 Then
		WScript.Echo "Failed to ExecuteGlobal include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If

	oFile.Close
End Sub
