Option Explicit
On Error Resume Next

Include "pva-agent-helper.vbs"

LogProgress "Executing " & Wscript.ScriptName
StopService PVA_SERVICE_NAME_SLAVE

StartService "Parallels Dispatcher Service"

Dim agentInstallFolder, agentBinFolder
agentInstallFolder = SafeGetInstallDir(0)
agentBinFolder = agentInstallFolder & "\bin"

RunCommandWithoutCheck """" & agentBinFolder & "\vzpInstallHelper.exe""" & " --vnc-configure"

StartService PVA_SERVICE_NAME_SLAVE

If Err.number = 0 Then
	LogProgress Wscript.ScriptName & " finished succesfully"
	WScript.Quit 0
Else
	FailedQuitErr "Failed to ConfigureHN"
End If

' Find Parallels Server installation folder
Function getParallelsFolder(ByRef prlInstallPath)
	On Error Resume Next
	Dim sho	
	Set sho = CreateObject("WScript.Shell")
	
	prlInstallPath = sho.RegRead ("HKLM\SOFTWARE\Parallels\Parallels Server\InstallLocation")
	If Err.number <> 0 Then
		Err.Clear
		prlInstallPath = sho.RegRead("HKLM\SOFTWARE\Wow6432Node\Parallels\Parallels Server\InstallLocation")
		If Err.number <> 0 Then
			getParallelsFolder = Err.number
			LogError Err.number, "Failed to get Parallels InstallLocation folder - " & Err.Description
			Exit Function
		End If
	End If

	If Right(prlInstallPath, 1) <> "\" Then prlInstallPath = prlInstallPath & "\"
	getParallelsFolder = 0
End Function

' Include vzlVBLib.vbs
Sub Include(cNameScript)
	On Error Resume Next
	Dim oFS, oFile
	
	cNameScript = Mid(Wscript.ScriptFullName, 1, InStrRev(Wscript.ScriptFullName, "\")) & cNameScript
	
	Set oFS = CreateObject("Scripting.Filesystemobject")
	
	Set oFile = oFS.OpenTextFile(cNameScript)
	If Err.number <> 0 Then
		WScript.Echo "Failed to open include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If
	
	ExecuteGlobal oFile.ReadAll()
	If Err.number <> 0 Then
		WScript.Echo "Failed to ExecuteGlobal include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If

	oFile.Close
End Sub
