Option Explicit
On Error Resume Next

Include "pva-agent-helper.vbs"

LogProgress "Executing " & Wscript.ScriptName
If IsVirtuozzoInstalled Then
	ConfigureVZ
End If
If Err.number = 0 Then
	LogProgress Wscript.ScriptName & " finished succesfully"
	WScript.Quit 0
Else
	FailedQuitErr "Failed to ConfigureMN"
End If

Sub ConfigureVZ
	LogProgress "Starting PVA Agent for Virtuozzo configuration"

	' UnRegister agent resource on an active cluster node
	If GetVzClusterState = PVA_CS_ACTIVE Then
		RunVzCluster("delagentresources")
	End If

	LogProgress "PVA Agent for Virtuozzo configured succesfully"
End Sub

' Include vzlVBLib.vbs
Sub Include(cNameScript)
	On Error Resume Next
	Dim oFS, oFile
	
	cNameScript = Mid(Wscript.ScriptFullName, 1, InStrRev(Wscript.ScriptFullName, "\")) & cNameScript
	
	Set oFS = CreateObject("Scripting.Filesystemobject")
	
	Set oFile = oFS.OpenTextFile(cNameScript)
	If Err.number <> 0 Then
		WScript.Echo "Failed to open include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If
	
	ExecuteGlobal oFile.ReadAll()
	If Err.number <> 0 Then
		WScript.Echo "Failed to ExecuteGlobal include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If

	oFile.Close
End Sub

Function IsVirtuozzoInstalled
	Dim msi, product
	Const Marker = " update "
	Const Virtuozzo = "Parallels Virtuozzo Containers "
	Set msi = CreateObject("WindowsInstaller.Installer")
	For Each product In msi.Products
		name = msi.ProductInfo(product, "ProductName")
		If Left(name, Len(Virtuozzo)) = Virtuozzo And InStrRev(name, Marker) = 0 Then
			IsVirtuozzoInstalled = True
			Exit Function
		End If
	Next
	IsVirtuozzoInstalled = False
End Function