Option Explicit
On Error Resume Next

Include "pva-agent-helper.vbs"

const PVA_MN_CORE=0

LogProgress "Executing " & Wscript.ScriptName

DoPreUpgrade

If Err.number = 0 Then
	LogProgress Wscript.ScriptName & " finished succesfully"
	WScript.Quit 0
Else
	FailedQuitErr "Failed to execute " & Wscript.ScriptName
End If

Sub DoPreUpgrade
	Dim f, v
	f = SafeGetDbScriptsFile(PVA_MN_CORE)
	DeleteFile f
	v = GetInstalledVersion
	If Not IsNull(v) And GetVzClusterState <> PVA_CS_STANDBY Then
		If v(2) <= 1722 Then
			WriteToFile f, "sqlit_46_463_upgrade.sql"
		End If
	End If
	StopService GetAgentServiceName(PVA_MN_CORE)
End Sub

' Include vzlVBLib.vbs
Sub Include(cNameScript)
	On Error Resume Next
	Dim oFS, oFile
	
	cNameScript = Mid(Wscript.ScriptFullName, 1, InStrRev(Wscript.ScriptFullName, "\")) & cNameScript
	
	Set oFS = CreateObject("Scripting.Filesystemobject")
	
	Set oFile = oFS.OpenTextFile(cNameScript)
	If Err.number <> 0 Then
		WScript.Echo "Failed to open include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If
	
	ExecuteGlobal oFile.ReadAll()
	If Err.number <> 0 Then
		WScript.Echo "Failed to ExecuteGlobal include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If

	oFile.Close
End Sub
