Option Explicit
On Error Resume Next

Include "pva-agent-helper.vbs"

LogProgress "Executing " & Wscript.ScriptName


Dim distribPackage, fso
distribPackage = SafeGetInstallDir(0) & "\distribution\" & PVA_AGENT_VZ_DISTRIBUTION_MSI 

Set fso = CreateObject("Scripting.FileSystemObject")
fso.DeleteFile distribPackage, True

If Err.number = 0 Then
	LogProgress Wscript.ScriptName & " finished succesfully"
	WScript.Quit 0
Else
	LogError Err.number, "Failed to configure P2V component of PVA Agent for Virtuozzo"
End If

	
' Include vzlVBLib.vbs
Sub Include(cNameScript)
	On Error Resume Next
	Dim oFS, oFile
	
	cNameScript = Mid(Wscript.ScriptFullName, 1, InStrRev(Wscript.ScriptFullName, "\")) & cNameScript
	
	Set oFS = CreateObject("Scripting.Filesystemobject")
	
	Set oFile = oFS.OpenTextFile(cNameScript)
	If Err.number <> 0 Then
		WScript.Echo "Failed to open include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If
	
	ExecuteGlobal oFile.ReadAll()
	If Err.number <> 0 Then
		WScript.Echo "Failed to ExecuteGlobal include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If

	oFile.Close
End Sub
