Option Explicit
On Error Resume Next

Include "pva-agent-helper.vbs"

const PVA_MN_CORE=1

LogProgress "Executing " & Wscript.ScriptName

DoPreUpgrade

If Err.number = 0 Then
	LogProgress Wscript.ScriptName & " finished succesfully"
	WScript.Quit 0
Else
	FailedQuitErr "Failed to execute " & Wscript.ScriptName
End If

Sub DoPreUpgrade
	Dim f, v
	f = SafeGetDbScriptsFile(PVA_MN_CORE)
	DeleteFile f
	v = GetInstalledVersion
	If Not IsNull(v) Then
		If v(1) = 5 Then
			WriteToFileEx f, "mssql_45_46_upgrade.sql" & vbCrLf, True
		End If
		If v(2) <= 1744 Then
			WriteToFileEx f, "mssql_46_463_upgrade.sql" & vbCrLf, True
		End If
		If v(2) <= 1913 Then
			WriteToFileEx f, "mssql_463_60_upgrade.sql" & vbCrLf, True
		End If
		If v(2) <= 2119 Then
			WriteToFileEx f, "mssql_60_601_upgrade.sql" & vbCrLf, True
		End If
		If v(2) <= 2152 Then
			WriteToFileEx f, "mssql_603_604_upgrade.sql" & vbCrLf, True
		End If
	End If
	StopService GetAgentServiceName(PVA_MN_CORE)
End Sub


' Include vzlVBLib.vbs
Sub Include(cNameScript)
	On Error Resume Next
	Dim oFS, oFile
	
	cNameScript = Mid(Wscript.ScriptFullName, 1, InStrRev(Wscript.ScriptFullName, "\")) & cNameScript
	
	Set oFS = CreateObject("Scripting.Filesystemobject")
	
	Set oFile = oFS.OpenTextFile(cNameScript)
	If Err.number <> 0 Then
		WScript.Echo "Failed to open include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If
	
	ExecuteGlobal oFile.ReadAll()
	If Err.number <> 0 Then
		WScript.Echo "Failed to ExecuteGlobal include file '" & cNameScript & "' - " & Err.source & ", " & Err.Description
		WScript.Quit(-1)
	End If

	oFile.Close
End Sub
